import requests
import json


ITS_URL = 'https://its.yandex-team.ru/v1/process/'
# {u'./oxcart_allow_ips_on_dummy': u'1'}


class ITS(object):
    def __init__(self, service_id, url=ITS_URL):
        self.service_id = service_id
        self.url = url
        self.headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
        }

    def get_its_roochquas(self):
        self.payload = {
            'f': [self.service_id],
        }
        r = requests.post(
            self.url,
            json=self.payload,
            headers=self.headers,
        )
        if r.status_code == 200:
            return r.json()

    def is_allowed(self):
        its_answer = self.get_its_roochquas()
        if its_answer.get('./oxcart_allow_ips_on_dummy', '') == '1':
            return True
        return False


if __name__ == '__main__':
    its = ITS('KvglQLPDsx9JF')
    print(its.get_its_roochquas())
    print(its.is_allowed())
