#include <infra/pod_agent/libs/client/main.h>
#include <infra/pod_agent/libs/daemon/main.h>
#include <infra/pod_agent/libs/exec_wrapper/main.h>
#include <infra/pod_agent/libs/interactive_log/main.h>

#include <infra/libs/logger/log_printer.h>

#include <library/cpp/getopt/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

int main(int argc, const char* argv[]) {
    TModChooser modChooser;

    modChooser.AddMode(
        "run",
        NInfra::NPodAgent::RunDaemon,
        "Run pod_agent daemon."
    );

    modChooser.AddMode(
        "print_log",
        NInfra::PrintEventLog,
        "Print pod_agent log."
    );

    modChooser.AddMode(
        "interactive_log",
        NInfra::NPodAgent::RunInteractiveLog,
        "Interactive viewer for pod_agent log."
    );

    modChooser.AddMode(
        "client",
        NInfra::NPodAgent::RunClient,
        "Run pod_agent client."
    );

    modChooser.AddMode(
        "exec_wrapper",
        NInfra::NPodAgent::RunExecWrapper,
        "Exec command with specific user and group."
    );

    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
