#pragma once

#include "node_status.h"
#include "node_types.h"
#include "tree_node.h"

#include <util/generic/noncopyable.h>

namespace NInfra::NPodAgent {

struct TBasicTreeNodeDescriptor {
    const ui64 Id;
    const TString Title;
};

class TBasicTreeNode;

using TBasicTreeNodePtr = TSimpleSharedPtr<TBasicTreeNode>;

class TBasicTreeNode : private TNonCopyable {
public:
    ui64 GetId() const {
        return Id_;
    }

    const TString& GetTitle() const {
        return Title_;
    }

    ENodeStatus GetStatus() const {
        return NodeStatus_;
    }

    TTickResult GetTickResult() const {
        return TickResult_;
    }

    TTickResult Tick(TTickContextPtr tickContext) {
        tickContext->Trace->Trace(GetId());

        TickResult_ = TickImpl(tickContext);

        if ((bool)TickResult_) {
            NodeStatus_ = TickResult_.Success().Status;
        }

        return TickResult_;
    }

    virtual ENodeType GetType() const = 0;

    virtual const TVector<TBasicTreeNodePtr>& GetChildren() const = 0;

    virtual ~TBasicTreeNode() = default;

protected:
    TBasicTreeNode(
        const TBasicTreeNodeDescriptor& descriptor
    )
        : Id_(descriptor.Id)
        , Title_(descriptor.Title)
        , NodeStatus_(ENodeStatus::IDLE)
        , TickResult_(TTickResult::DefaultSuccess())
    {}

private:

    virtual TTickResult TickImpl(TTickContextPtr tickContext) = 0;

private:
    const ui64 Id_;
    const TString Title_;

    ENodeStatus NodeStatus_;
    TTickResult TickResult_;
};

} // namespace NInfra::NPodAgent
