#pragma once

namespace NInfra::NPodAgent {

enum class ENodeStatus {
    // Enumerates the states every node can be in after execution during a particular
    // time step:
    // - "Success" indicates that the node has completed running during this time step;
    // - "Failure" indicates that the node has determined it will not be able to complete
    //   its task;
    // - "Running" indicates that the node has successfully moved forward during this
    //   time step, but the task is not yet complete;
    RUNNING,
    SUCCESS,
    FAILURE,
    IDLE
};

} // namespace NInfra::NPodAgent
