#pragma once

#include <util/system/types.h>

namespace NInfra::NPodAgent {

enum class ENodeType : ui8 {
    UNKNOWN                                                     =   0 /* "Unknown" */,
    MEM_SEQUENCE_GENERATOR                                      =   1 /* "MemSequenceGenerator" */,
    SUCCEEDER                                                   =   2 /* "Succeeder" */,
    FAILER                                                      =   3 /* "Failer" */,
    ERROR                                                       =   4 /* "Error" */,
    PORTO_CONTAINER_EXISTS                                      =   5 /* "PortoContainerExists" */,
    PORTO_CREATE_RECURSIVE                                      =   7 /* "PortoCreateRecursive" */,
    PORTO_START                                                 =   8 /* "PortoStart" */,
    PORTO_STOP                                                  =   9 /* "PortoStop" */,
    PORTO_DESTROY                                               =  10 /* "PortoDestroy" */,
    PORTO_KILL                                                  =  11 /* "PortoKill" */,
    PORTO_GET_AND_CHECK_PROPERTIES                              =  12 /* "PortoGetAndCheckProperties" */,
    PORTO_GET_DOWNLOAD_PROGRESS                                 =  13 /* "PortoGetDownloadProgress" */,
    PORTO_GET_AND_CHECK_VOLUME_PROPERTIES                       =  14 /* "PortoGetAndCheckVolumeProperties" */,
    PORTO_SET_PROPERTY                                          =  15 /* "PortoSetProperty" */,
    PORTO_CONTAINER_PROPERTY_MATCHES                            =  16 /* "PortoContainerPropertyMatches" */,
    PORTO_CONTAINER_TREE_HASH_MATCHES                           =  17 /* "PortoContainerTreeHashMatches" */,
    PORTO_GET_CONTAINER_PRIVATE                                 =  18 /* "PortoGetContainerPrivate" */,
    PORTO_CONTAINER_PRIVATE_MATCHES                             =  19 /* "PortoContainerPrivateMatches" */,
    PORTO_GET_LAYER_PRIVATE                                     =  20 /* "PortoGetLayerPrivate" */,
    PORTO_GET_CONTAINER_STATE                                   =  21 /* "PortoGetContainerState" */,
    PORTO_SET_CONTAINER_PRIVATE                                 =  22 /* "PortoSetContainerPrivate" */,
    CONTAINER_START_TIME_EXPIRED_WITH_BACK_OFF                  =  23 /* "ContainerStartTimeExpiredWithBackOff" */,
    PORTO_CONTAINER_TIME_EXPIRED                                =  24 /* "PortoContainerTimeExpired" */,
    PORTO_STATIC_RESOURCE_VERIFY_CONTAINER_TIME_EXPIRED         =  25 /* "PortoStaticResourceVerifyContainerTimeExpired" */,
    FILE_MODIFIED_BEFORE_PORTO_CONTAINER_START                  =  26 /* "FileModifiedBeforePortoContainerStart" */,
    FILE_MODIFIED_RECURSIVE_BEFORE_PORTO_CONTAINER_START        =  27 /* "FileModifiedRecursiveBeforePortoContainerStart" */,
    PORTO_VOLUME_EXISTS                                         =  28 /* "PortoVolumeExists" */,
    PORTO_CREATE_VOLUME                                         =  30 /* "PortoCreateVolume" */,
    PORTO_LINK_VOLUME                                           =  31 /* "PortoLinkVolume" */,
    PORTO_UNLINK_VOLUME                                         =  32 /* "PortoUnlinkVolume" */,
    PORTO_VOLUME_IS_LINK_OF                                     =  33 /* "PortoVolumeIsLinkOf" */,
    PORTO_LAYER_EXISTS                                          =  34 /* "PortoLayerExists" */,
    PORTO_LAYERS_READY                                          =  35 /* "PortoLayersReady" */,
    PORTO_SET_LAYER_PRIVATE                                     =  36 /* "PortoSetLayerPrivate" */,
    PORTO_IMPORT_LAYER                                          =  37 /* "PortoImportLayer" */,
    PORTO_REMOVE_LAYER                                          =  38 /* "PortoRemoveLayer" */,
    PORTO_CLEAN_LINKED_VOLUMES                                  =  39 /* "PortoCleanLinkedVolumes" */,
    PORTO_CLEAN_OLD_CONTAINERS                                  =  40 /* "PortoCleanOldContainers" */,
    FEEDBACK_OBJECT_STATE                                       =  41 /* "FeedbackObjectState" */,
    FEEDBACK_OBJECT_DOWNLOAD_COMPLETE                           =  42 /* "FeedbackObjectDownloadComplete" */,
    STATIC_RESOURCE_STATE_MATCHES                               =  43 /* "StaticResourceStateMatches" */,
    FEEDBACK_OBJECT_FAILED_MESSAGE                              =  44 /* "FeedbackObjectFailedMessage" */,
    FEEDBACK_OBJECT_IP_ADDRESS                                  =  45 /* "FeedbackObjectIpAddress" */,
    SET_WORKLOAD_WAS_DESTROYED_BY_HOOK                          =  46 /* "SetWorkloadWasDestroyedByHook" */,
    WORKLOAD_SHOULD_BE_DESTROYED_BY_HOOK                        =  47 /* "WorkloadShouldBeDestroyedByHook" */,
    PORTO_ADD_PROPERTIES_TO_OBJECT_FAILED_MESSAGE               =  48 /* "PortoAddPropertiesToObjectFailedMessage" */,
    FEEDBACK_OBJECT_VERIFY_ATTEMPT                              =  49 /* "FeedbackObjectVerifyAttempt" */,
    PORTO_STORAGE_PRIVATE_MATCHES                               =  50 /* "PortoStoragePrivateMatches" */,
    PORTO_REMOVE_STORAGE                                        =  51 /* "PortoRemoveStorage" */,
    FEEDBACK_OBJECT_CHECK_FAILED_MESSAGE                        =  52 /* "FeedbackObjectCheckFailedMessage" */,
    FEEDBACK_OBJECT_DOWNLOAD_ATTEMPT                            =  53 /* "FeedbackObjectDownloadAttempt" */,
    CHECK_CONTAINER_RETRIES                                     =  54 /* "CheckContainerRetries" */,
    WORKLOAD_TARGET_ACTIVE                                      =  55 /* "WorkloadTargetActive" */,
    FEEDBACK_CONTAINER_FAIL_REASON                              =  57 /* "FeedbackContainerFailReason" */,
    FEEDBACK_CONTAINER_STATE                                    =  58 /* "FeedbackContainerState" */,
    FEEDBACK_CONTAINER_STATUS                                   =  59 /* "FeedbackContainerStatus" */,
    FEEDBACK_CONTAINER_START_TIME                               =  60 /* "FeedbackContainerStartTime" */,
    FEEDBACK_CONTAINER_DEATH_TIME                               =  61 /* "FeedbackContainerDeathTime" */,
    FEEDBACK_CONTAINER_STDERR                                   =  62 /* "FeedbackContainerStderr" */,
    FEEDBACK_CONTAINER_STDOUT                                   =  63 /* "FeedbackContainerStdout" */,
    FEEDBACK_CONTAINER_OWNER_STATE                              =  64 /* "FeedbackContainerOwnerState" */,
    VARIABLE_IS_SET                                             =  65 /* "VariableIsSet" */,
    MAKE_DIRECTORY                                              =  66 /* "MakeDirectory" */,
    MAKE_LOG_FILE                                               =  67 /* "MakeLogFile" */,
    FILE_EXISTS                                                 =  68 /* "FileExists" */,
    MAKE_HARD_LINK                                              =  69 /* "MakeHardLink" */,
    MAKE_SYM_LINK                                               =  70 /* "MakeSymLink" */,
    REMOVE_FILE                                                 =  71 /* "RemoveFile" */,
    REMOVE_RECURSIVE                                            =  72 /* "RemoveRecursive" */,
    CHECK_HTTP_HOOK_RETRIES                                     =  83 /* "CheckHttpHookRetries" */,
    FEEDBACK_HTTP_HOOK_FAIL_REASON                              =  84 /* "FeedbackHttpHookFailReason" */,
    CAPTURE_NETWORK_HOOK_STATUS                                 =  85 /* "CaptureNetworkHookStatus" */,
    CAPTURE_CONTAINER_STATUS                                    =  86 /* "CaptureContainerStatus" */,
    ADD_IP_ADDRESS                                              =  87 /* "AddIpAddress" */,
    MEM_SEQUENCE                                                =  88 /* "MemSequence" */,
    MEM_SELECTOR                                                =  89 /* "MemSelector" */,
    INVERTER                                                    =  90 /* "Inverter" */,
    CASE                                                        =  91 /* "Case" */,
    SWITCH                                                      =  92 /* "Switch" */,
    STATIC_SWITCH                                               =  93 /* "StaticSwitch" */,
    TIMED_CACHE                                                 =  94 /* "TimedCache" */,
    TRY_LOCK                                                    =  95 /* "TryLock" */,
    MOCK                                                        =  96 /* "Mock" */,
    NETWORK_REMOVE_REQUEST                                      =  97 /* "NetworkRemoveRequest" */,
    CHECK_SAME_INODE                                            =  98 /* "CheckSameINode" */,
    NETWORK_HOOK_CONSECUTIVE_TRIES_REACHED                      =  99 /* "NetworkHookConsecutiveTriesReached" */,
    NETWORK_HOOK_START_TIME_EXPIRED_WITH_BACKOFF                = 100 /* "NetworkHookStartTimeExpiredWithBackoff" */,
    NETWORK_GET_REQUEST_STATE                                   = 101 /* "NetworkGetRequestState" */,
    PORTO_ACTIVE_DOWNLOAD_CONTAINERS_LIMIT_REACHED              = 102 /* "PortoActiveDownloadContainersLimitReached" */,
    FEEDBACK_NETWORK_HOOK_STATE                                 = 103 /* "FeedbackNetworkHookState" */,
    NETWORK_CHECK_AND_ADD_REQUEST                               = 104 /* "NetworkCheckAndAddRequest" */,
    NETWORK_GET_AND_REMOVE_REQUEST_RESPONSE                     = 105 /* "NetworkGetAndRemoveRequestResponse" */,
    CONTAINER_CONSECUTIVE_TRIES_REACHED                         = 106 /* "ContainerConsecutiveTriesReached" */,
    LAYER_KEEP_SOURCE_FILE_AFTER_IMPORT                         = 107 /* "LayerKeepSourceFileAfterImport" */,
    CAPTURE_UNIX_SIGNAL_STATUS                                  = 108 /* "CaptureUnixSignalStatus" */,
    CHECK_UNIX_SIGNAL_RETRIES                                   = 109 /* "CheckUnixSignalRetries" */,
    FEEDBACK_UNIX_SIGNAL_STATE                                  = 110 /* "FeedbackUnixSignalState" */,
    UNIX_SIGNAL_SEND_TIME_EXPIRED_WITH_BACKOFF                  = 111 /* "UnixSignalSendTimeExpiredWithBackoff" */,
    PORTO_KILL_WITH_UNIX_SIGNAL_FEEDBACK                        = 112 /* "PortoKillWithUnixSignalFeedback" */,
    WORKLOAD_CLEAR_STOP_STATUS                                  = 113 /* "WorkloadClearStopStatus" */,
    WORKLOAD_CLEAR_DESTROY_STATUS                               = 114 /* "WorkloadClearDestroyStatus" */,
    PORTO_ADD_PROPERTIES_TO_CONTAINER_FAIL_REASON               = 115 /* "PortoAddPropertiesToContainerFailReason" */,
    PORTO_SET_PROPERTIES                                        = 116 /* "PortoSetProperties" */,
    SET_FILE_ACCESS_MODE_RECURSIVE                              = 117 /* "SetFileAccessModeRecursive" */,
    PORTO_STORAGE_EXISTS                                        = 118 /* "PortoStorageExists" */,
    FILE_MODIFIED_BEFORE_PORTO_VOLUME_BUILD                     = 119 /* "FileModifiedBeforePortoVolumeBuild" */,
    IS_DIRECTORY                                                = 120 /* "IsDirectory" */,
    PORTO_ACTIVE_VERIFY_CONTAINERS_LIMIT_REACHED                = 121 /* "PortoActiveVerifyContainersLimitReached" */
};

} // namespace NInfra::NPodAgent
