#pragma once

#include "basic_tree_node.h"
#include "tree_tracer.h"

#include <infra/libs/logger/logger.h>

#include <util/generic/hash.h>

namespace NInfra::NPodAgent {

class TTree;

using TTreePtr = TAtomicSharedPtr<TTree>;
using TTreeConstPtr = TAtomicSharedPtr<const TTree>;

class TTree : private TNonCopyable {
public:
    TTree(
        TLogger& logger
        , const TString& treeId
        , TBasicTreeNodePtr rootNode
    )
        : Logger_(logger)
        , TreeId_(treeId)
        , RootNode_(rootNode)
    {}

    virtual ~TTree() = default;

    TTickResult Tick() {
        TickContext_= MakeSimpleShared<TTickContext>(
            Logger_.SpawnFrame(),
            MakeSimpleShared<TTreeTracer>()
        );
        auto result = RootNode_->Tick(TickContext_);
        return result;
    }

    virtual bool GetUseLongTickPeriod() const {
        return false;
    }

    size_t GetLongTickPeriodDuration() const {
        return TickContext_->GetLongTickPeriodDuration();
    }

    const TBasicTreeNodePtr& GetRootNode() const {
        return RootNode_;
    }

    const TTreeTracerPtr GetTrace() const {
        return TickContext_ ? TickContext_->Trace : new TTreeTracer();
    }

    const TString& GetTreeId() const {
        return TreeId_;
    }

private:
    TLogger& Logger_;
    const TString TreeId_;
    TBasicTreeNodePtr RootNode_;
    TTickContextPtr TickContext_;
};

} // namespace NInfra::NPodAgent
