#pragma once

#include "node_status.h"
#include "tree_tracer.h"

#include <infra/libs/logger/logger.h>
#include <infra/libs/logger/log_frame.h>
#include <infra/libs/outcome/result.h>

#include <util/generic/ptr.h>

namespace NInfra::NPodAgent {

struct TNodeSuccess {
    ENodeStatus Status;
    TString Message;

    TNodeSuccess(ENodeStatus status = ENodeStatus::IDLE, const TString& message = "")
        : Status(status)
        , Message(message)
    {}

    bool operator==(const TNodeSuccess& rhs) const {
        return (this->Status == rhs.Status)
            && (this->Message == rhs.Message);
    }
};

struct TNodeError {
    TString Message = "";

    bool operator==(const TNodeError& rhs) const {
        return this->Message == rhs.Message;
    }
};
using TTickId = size_t;

class TTickContext {
public:
    TTickContext(TLogFramePtr logFrame, TTreeTracerPtr trace)
        : LogFrame(logFrame)
        , Trace(trace)
        , PeriodDurationMs_(std::numeric_limits<size_t>::max())
    {}

    void UpdateLongTickPeriodDuration(size_t duration) {
        PeriodDurationMs_ = Min(duration, PeriodDurationMs_);
    }

    size_t GetLongTickPeriodDuration() {
        return PeriodDurationMs_;
    }

public:
    TLogFramePtr LogFrame;
    TTreeTracerPtr Trace;

private:
    size_t PeriodDurationMs_;
};

using TTickContextPtr = TSimpleSharedPtr<TTickContext>;
using TTickResult = TExpected<TNodeSuccess, TNodeError>;

} // namespace NInfra::NPodAgent
