#pragma once

#include <util/generic/ptr.h>
#include <util/generic/hash_set.h>

namespace NInfra::NPodAgent {

class TTreeTracer;
using TTreeTracerPtr = TSimpleSharedPtr<TTreeTracer>;

class TTreeTracer {
public:
    TTreeTracer()
        : Trace_()
    {}

    void Trace(ui64 nodeId) {
        Trace_.insert(nodeId);
    }

    const THashSet<ui64>& GetTrace() const {
        return Trace_;
    }

private:
    THashSet<ui64> Trace_;
};

} // namespace NInfra::NPodAgent
