#pragma once

#include "basic_leaf.h"

#include <util/datetime/base.h>

namespace NInfra::NPodAgent {

static const TDuration ASYNC_NODE_TIMEOUT = TDuration::MilliSeconds(10);

template<class T>
class TAsyncNode : public TBasicLeaf {
public:
    TAsyncNode(
        const TBasicTreeNodeDescriptor& descriptor
    )
        : TBasicLeaf(descriptor)
    {
    }

private:
    TExpected<T, TTickResult> TickWithFuture(TTickContextPtr context) {
        if (!Future_.Initialized()) {
            Future_ = OUTCOME_TRYX(PrepareFuture(context));
        }
        if (Future_.Wait(ASYNC_NODE_TIMEOUT)) {
            T result = Future_.GetValueSync();
            Future_ = NThreading::TFuture<T>(); // reset future
            return result;
        } else {
            return TTickResult(ENodeStatus::RUNNING);
        }
    }

    TTickResult TickImpl(TTickContextPtr context) override final {
        T futureResult = OUTCOME_TRYX(TickWithFuture(context));
        return ProcessFutureResult(context, futureResult);
    }

    virtual TExpected<NThreading::TFuture<T>, TTickResult> PrepareFuture(TTickContextPtr context) = 0;
    virtual TTickResult ProcessFutureResult(TTickContextPtr context, T& result) = 0;

private:
    NThreading::TFuture<T> Future_;
};

} // namespace NInfra::NPodAgent
