#pragma once

#include <infra/pod_agent/libs/behaviour/bt/core/basic_tree_node.h>

namespace NInfra::NPodAgent {

class TBasicCompositeNode;
using TBasicCompositeNodePtr = TSimpleSharedPtr<TBasicCompositeNode>;

class TBasicCompositeNode : public TBasicTreeNode {
public:
    TBasicCompositeNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TVector<TBasicTreeNodePtr> Children
    )
        : TBasicTreeNode(descriptor)
        , Children_(std::move(Children))
    {}

    virtual const TVector<TBasicTreeNodePtr>& GetChildren() const override final;
    virtual void SetChildren(TVector<TBasicTreeNodePtr>&& children);

private:
    TVector<TBasicTreeNodePtr> Children_;
};

} // namespace NInfra::NPodAgent
