#pragma once

#include "async_node.h"

#include <infra/pod_agent/libs/system_logs_sender/system_logs_sender.h>

#include <library/cpp/protobuf/json/proto2json.h>

namespace NInfra::NPodAgent {

template<class T>
class TCaptureStatusBasicNode : public TAsyncNode<T> {
public:
    TCaptureStatusBasicNode(
        const TBasicTreeNodeDescriptor& descriptor
        , ISystemLogsSenderPtr systemLogsSender
    )
        : TAsyncNode<T>(descriptor)
        , SystemLogsSender_(systemLogsSender)
    {
        Y_ENSURE(SystemLogsSender_, "system logs sender not defined for TCaptureStatusBasicNode");
    }

protected:
    template <typename EventType>
    static TString LogEventToMessage(EventType event) {
        NProtobufJson::TProto2JsonConfig config;
        config.SetEnumMode(NProtobufJson::TProto2JsonConfig::EnumName);            
        return NProtobufJson::Proto2Json(event, config);
    }

private:
    virtual TExpected<TFuture<T>, TTickResult> PrepareFuture(TTickContextPtr context) override final {
        return CaptureStatus(context);
    }

    virtual TTickResult ProcessFutureResult(TTickContextPtr context, T& result) override final {
        return ProcessResult(context, result);
    }

    virtual TExpected<NThreading::TFuture<T>, TTickResult> CaptureStatus(TTickContextPtr context) = 0;
    virtual TTickResult ProcessResult(TTickContextPtr context, T& result) = 0;

protected:
    ISystemLogsSenderPtr SystemLogsSender_;
};

} // namespace NInfra::NPodAgent
