#include "common.h"

namespace NInfra::NPodAgent {

TDuration RoundToSeconds(TDuration duration) {
    TDuration result = TDuration::Seconds(duration.Seconds() + (duration.MicroSecondsOfSecond() > 0 ? 1 : 0));
    if (result < duration) { // catch overflow on duration == UINT64_MAX
        result = TDuration::Seconds(duration.Seconds());
    }
    return result;
}

TString GetStringFromState(TStatusRepositoryCommon::TObjectState state) {
    if (std::holds_alternative<API::EBoxState>(state)) {
        return NSupport::ExtractState(API::EBoxState_Name(std::get<API::EBoxState>(state)));
    } else if (std::holds_alternative<API::EVolumeState>(state)) {
        return NSupport::ExtractState(API::EVolumeState_Name(std::get<API::EVolumeState>(state)));
    } else if (std::holds_alternative<API::EWorkloadState>(state)) {
        return NSupport::ExtractState(API::EWorkloadState_Name(std::get<API::EWorkloadState>(state)));
    } else if (std::holds_alternative<API::EStaticResourceState>(state)) {
        return NSupport::ExtractState(API::EStaticResourceState_Name(std::get<API::EStaticResourceState>(state)));
    } else if (std::holds_alternative<API::ELayerState>(state)) {
        return NSupport::ExtractState(API::ELayerState_Name(std::get<API::ELayerState>(state)));
    } else {
        ythrow yexception() << "Cannot parse state: " << state.index();
    }
}

NLogEvent::EPodAgentObjectType GetObjectTypeFromEnum(const NStatusRepositoryTypes::EObjectType type) {
    switch (type) {
        case NStatusRepositoryTypes::EObjectType::BOX:
            return NLogEvent::EPodAgentObjectType::BOX;
        case NStatusRepositoryTypes::EObjectType::LAYER:
            return NLogEvent::EPodAgentObjectType::LAYER;
        case NStatusRepositoryTypes::EObjectType::STATIC_RESOURCE:
            return NLogEvent::EPodAgentObjectType::STATIC_RESOURCE;
        case NStatusRepositoryTypes::EObjectType::VOLUME:
            return NLogEvent::EPodAgentObjectType::VOLUME;
        case NStatusRepositoryTypes::EObjectType::WORKLOAD:
            return NLogEvent::EPodAgentObjectType::WORKLOAD;
    }
    ythrow yexception() << "Cannot parse type: " << ToString(type);
}

NLogEvent::TContainerAttemptFeedback::EContainerType GetContainerTypeFromEnum(const NStatusRepositoryTypes::TContainerDescription::EContainerType type) {
    switch (type) {
        case NStatusRepositoryTypes::TContainerDescription::DESTROY:
            return NLogEvent::TContainerAttemptFeedback::DESTROY;
        case NStatusRepositoryTypes::TContainerDescription::DOWNLOAD:
            return NLogEvent::TContainerAttemptFeedback::DOWNLOAD;
        case NStatusRepositoryTypes::TContainerDescription::INIT:
            return NLogEvent::TContainerAttemptFeedback::INIT;
        case NStatusRepositoryTypes::TContainerDescription::LIVENESS:
            return NLogEvent::TContainerAttemptFeedback::LIVENESS;
        case NStatusRepositoryTypes::TContainerDescription::META:
            return NLogEvent::TContainerAttemptFeedback::META;
        case NStatusRepositoryTypes::TContainerDescription::READINESS:
            return NLogEvent::TContainerAttemptFeedback::READINESS;
        case NStatusRepositoryTypes::TContainerDescription::START:
            return NLogEvent::TContainerAttemptFeedback::START;
        case NStatusRepositoryTypes::TContainerDescription::STOP:
            return NLogEvent::TContainerAttemptFeedback::STOP;
        case NStatusRepositoryTypes::TContainerDescription::VERIFY:
            return NLogEvent::TContainerAttemptFeedback::VERIFY;
    }
    ythrow yexception() << "Cannot parse container type: " << ToString(type);
}

NLogEvent::EPodAgentNetworkHookType GetNetworkHookTypeFromEnum(const NStatusRepositoryTypes::ENetworkHookType type) {
    switch (type) {
        case NStatusRepositoryTypes::ENetworkHookType::READINESS:
            return NLogEvent::EPodAgentNetworkHookType::READINESS;
        case NStatusRepositoryTypes::ENetworkHookType::LIVENESS:
            return NLogEvent::EPodAgentNetworkHookType::LIVENESS;
        case NStatusRepositoryTypes::ENetworkHookType::STOP:
            return NLogEvent::EPodAgentNetworkHookType::STOP;
        case NStatusRepositoryTypes::ENetworkHookType::DESTROY:
            return NLogEvent::EPodAgentNetworkHookType::DESTROY;
    }
    ythrow yexception() << "Cannot parse object type: " << ToString(type);
}

} // namespace NInfra::NPodAgent
