#pragma once

#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/support_functions.h>

#include <util/datetime/base.h>

namespace NInfra::NPodAgent {

// Round duration up to seconds because porto returns time in seconds
TDuration RoundToSeconds(TDuration duration);

TString GetStringFromState(TStatusRepositoryCommon::TObjectState state);
NLogEvent::EPodAgentObjectType GetObjectTypeFromEnum(const NStatusRepositoryTypes::EObjectType type);
NLogEvent::TContainerAttemptFeedback::EContainerType GetContainerTypeFromEnum(const NStatusRepositoryTypes::TContainerDescription::EContainerType type);
NLogEvent::EPodAgentNetworkHookType GetNetworkHookTypeFromEnum(const NStatusRepositoryTypes::ENetworkHookType type);

} // namespace NInfra::NPodAgent
