#pragma once

#include "basic_leaf.h"

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TFeedbackContainerBasicNode : public TBasicLeaf {
public:
    TFeedbackContainerBasicNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr containerStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
    )
        : TBasicLeaf(descriptor)
        , ContainerStatusRepository_(containerStatusRepository)
        , Container_(container)
    {
        Y_ENSURE(ContainerStatusRepository_, "ContainerStatusRepository not defined for TFeedbackContainerBasicNode");
    }

protected:
    const TStatusRepositoryCommonPtr ContainerStatusRepository_;
    const NStatusRepositoryTypes::TContainerDescription Container_;
};

} // namespace NInfra::NPodAgent
