#include "feedback_container_stream_basic_node.h"

namespace NInfra::NPodAgent {

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TFeedbackContainerStreamBasicNode::PortoCall(TTickContextPtr /*context*/) {
    if (ContainerField_ == EContainerField::Stderr) {
        return Porto_->GetStderr(ContainerName_, OFFSET, LENGTH);
    }
    if (ContainerField_ == EContainerField::Stdout) {
        return Porto_->GetStdout(ContainerName_, OFFSET, LENGTH);
    }
    return TTickResult{TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': unhandled container field type"}};
}

TTickResult TFeedbackContainerStreamBasicNode::ProcessPortoResultSuccess(TTickContextPtr /*context*/, TString& result) {
    try {
        UpdateWorkloadContainerStatus(result);
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } catch (const yexception& e) {
        return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
    }
}

TTickResult TFeedbackContainerStreamBasicNode::ProcessPortoResultError(TTickContextPtr context, TPortoError& result) {
    if (result.Code == EPortoError::Busy
        // Special case when error is not critical
        // For example stdout/stderr file is non-regular (fifo)
        || result.Code == EPortoError::InvalidData
    ) {
        try {
            UpdateWorkloadContainerStatus(
                TStringBuilder() << "[Porto client failed to get container stream]: '" << ToString(result) << "'"
            );
            return TNodeSuccess(ENodeStatus::SUCCESS);
        } catch (const yexception& e) {
            return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
        }
    } else {
        return TPortoBasicContainerNode<TString>::ProcessPortoResultError(context, result);
    }
}

} // namespace NInfra::NPodAgent
