#pragma once

#include "porto_basic_container_node.h"

namespace NInfra::NPodAgent {

class TFeedbackContainerStreamBasicNode : public TPortoBasicContainerNode<TString> {
public:
    enum EContainerField {
        Stderr = 0,
        Stdout = 1
    };

public:
    TFeedbackContainerStreamBasicNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr containerStatusRepository
        , TAsyncPortoClientPtr porto
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TPortoContainerName& containerName
        , EContainerField containerField
    )
        : TPortoBasicContainerNode(descriptor, porto, containerStatusRepository, container, containerName)
        , ContainerField_(containerField)
    {
        Y_ENSURE(ContainerField_ == EContainerField::Stderr || ContainerField_ == EContainerField::Stdout, "unhandled container field type for TFeedbackContainerStreamBasicNode");
    }

private:
    virtual void UpdateWorkloadContainerStatus(const TString& result) = 0;

    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResultSuccess(TTickContextPtr context, TString& result) override final;
    virtual TTickResult ProcessPortoResultError(TTickContextPtr context, TPortoError& result) override final;

protected:
    static constexpr const i32 OFFSET = -1;
    static constexpr const i32 LENGTH = (1 << 12);

    const EContainerField ContainerField_;
};

} // namespace NInfra::NPodAgent
