#pragma once

#include "basic_leaf.h"

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TFeedbackObjectBasicNode : public TBasicLeaf {
public:
    TFeedbackObjectBasicNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr statusRepositoryCommon
        , const TString& objectIdOrHash
    )
        : TBasicLeaf(descriptor)
        , StatusRepositoryCommon_(statusRepositoryCommon)
        , ObjectIdOrHash_(objectIdOrHash)
    {
        Y_ENSURE(StatusRepositoryCommon_, "StatusRepositoryCommon not defined for TFeedbackObjectBasicNode");
    }

protected:
    const TStatusRepositoryCommonPtr StatusRepositoryCommon_;
    const TString ObjectIdOrHash_;
};

} // namespace NInfra::NPodAgent
