#pragma once

#include "async_node.h"

#include <infra/pod_agent/libs/ip_client/async_client.h>

namespace NInfra::NPodAgent {

/*
    Node with async call to IpClient
        Child may return either
          Future<T> or ready TTickResult at IpClientCall()
        In case of future child should process
          its value at ProcessIpClientResult()
          and return TTickResult
*/
template<class T>
class TIpOperationsBasicNode : public TAsyncNode<T> {
public:
    TIpOperationsBasicNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncIpClientPtr ipClient
    )
        : TAsyncNode<T>(descriptor)
        , IpClient_(ipClient)
    {
        Y_ENSURE(IpClient_, "IpClient not defined for TIpOperationsBasicNode");
    }

private:
    virtual TExpected<TFuture<T>, TTickResult> PrepareFuture(TTickContextPtr context) override final {
        return IpClientCall(context);
    }

    virtual TTickResult ProcessFutureResult(TTickContextPtr context, T& result) override final {
        return ProcessIpClientResult(context, result);
    }

    virtual TExpected<NThreading::TFuture<T>, TTickResult> IpClientCall(TTickContextPtr context) = 0;
    virtual TTickResult ProcessIpClientResult(TTickContextPtr context, T& result) = 0;

protected:
    TAsyncIpClientPtr IpClient_;
};

} // namespace NInfra::NPodAgent
