#pragma once

#include "basic_leaf.h"

namespace NInfra::NPodAgent {

class TMockNode;
using TMockNodePtr = TSimpleSharedPtr<TMockNode>;

class TMockNode : public TBasicLeaf {
public:
    TMockNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TTickResult tickResult
        , ENodeType nodeType = TMockNode::NODE_TYPE
    )
        : TBasicLeaf(descriptor), TickResult_(std::move(tickResult))
        , NodeType_(nodeType)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr) override final;

public:
    // Default node type
    static constexpr const ENodeType NODE_TYPE = ENodeType::MOCK;

private:
    const TTickResult TickResult_;

    // Mock node also used as succeeder node, failer node and error node
    const ENodeType NodeType_;
};

} // namespace NInfra::NPodAgent
