#pragma once

#include "workload_basic_node.h"

#include <infra/pod_agent/libs/network_client/client.h>

namespace NInfra::NPodAgent {

template<class T>
class TNetworkBasicNode : public TWorkloadBasicNode {
public:
    TNetworkBasicNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
        , NStatusRepositoryTypes::ENetworkHookType networkHookType
        , const TString& requestHash
        , TNetworkClientPtr networkClient
    )
        : TWorkloadBasicNode(
            descriptor
            , workloadStatusRepository
            , workloadId
        )
        , NetworkHookType_(networkHookType)
        , RequestHash_(requestHash)
        , NetworkClient_(networkClient)
    {
        Y_ENSURE(NetworkClient_, "NetworkClient_ not defined for TNetworkBasicNode");
    }

protected:
    TTickResult TickImpl(TTickContextPtr context) override final {
        T result = NetworkClientCall(context);
        return ProcessNetworkClientResult(context, result);
    }

    TString GetRequestKey() const {
        return TStringBuilder() << WorkloadId_ << "_" << ToString(NetworkHookType_);
    }

    TString MakeFullErrorMessage(TString errorDetails) const {
        TString hookDescription;
        switch (NetworkHookType_) {
            case NStatusRepositoryTypes::LIVENESS:
            case NStatusRepositoryTypes::READINESS:
                return TStringBuilder() << ToString(NetworkHookType_) << " probe failed: " << errorDetails;
            case NStatusRepositoryTypes::STOP:
            case NStatusRepositoryTypes::DESTROY:
                return TStringBuilder() << ToString(NetworkHookType_) << " policy failed: " << errorDetails;
        }
    }

    virtual T NetworkClientCall(TTickContextPtr context) = 0;
    virtual TTickResult ProcessNetworkClientResult(TTickContextPtr context, T& result) = 0;

protected:
    const NStatusRepositoryTypes::ENetworkHookType NetworkHookType_;
    const TString RequestHash_;

    const TNetworkClientPtr NetworkClient_;
};

} // namespace NInfra::NPodAgent
