#pragma once

#include "porto_basic_node.h"

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

/**
    Enhances TPortoBasicNode withNStatusRepositoryTypes::TContainerDescription and TStatusRepositoryCommonPtr
*/
template<class T>
class TPortoBasicContainerNode : public TPortoBasicNode<TExpected<T, TPortoError>> {
public:
    TPortoBasicContainerNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , TStatusRepositoryCommonPtr containerStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TPortoContainerName& containerName
    )
        : TPortoBasicNode<TExpected<T, TPortoError>>(descriptor, porto)
        , ContainerStatusRepository_(containerStatusRepository)
        , Container_(container)
        , ContainerName_(containerName)
    {
        Y_ENSURE(ContainerStatusRepository_, "ContainerStatusRepository not defined for TPortoBasicContainerNode");
    }

protected:
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<T, TPortoError>& result) override final {
        if (result) {
            return ProcessPortoResultSuccess(context, result.Success());
        } else {
            return ProcessPortoResultError(context, result.Error());
        }
    }

    virtual TTickResult ProcessPortoResultSuccess(TTickContextPtr /* context */, T& /* result */) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    }

    virtual TTickResult ProcessPortoResultError(TTickContextPtr /* context */, TPortoError& result) {
        ContainerStatusRepository_->UpdateContainerFailReason(Container_, ToString(result));
        ContainerStatusRepository_->IncrementContainerSystemFailureCounter(Container_);

        return TNodeError{
            ToString(result)
        };
    }

protected:
    const TStatusRepositoryCommonPtr ContainerStatusRepository_;
    const NStatusRepositoryTypes::TContainerDescription Container_;
    const TPortoContainerName ContainerName_;
};

template<>
class TPortoBasicContainerNode<void> : public TPortoBasicNode<TExpected<void, TPortoError>> {
public:
    TPortoBasicContainerNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , TStatusRepositoryCommonPtr containerStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TPortoContainerName& containerName
    )
        : TPortoBasicNode<TExpected<void, TPortoError>>(descriptor, porto)
        , ContainerStatusRepository_(containerStatusRepository)
        , Container_(container)
        , ContainerName_(containerName)
    {
        Y_ENSURE(ContainerStatusRepository_, "ContainerStatusRepository not defined for TPortoBasicContainerNode");
    }

protected:
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<void, TPortoError>& result) override final {
        if (result) {
            return ProcessPortoResultSuccess(context);
        } else {
            return ProcessPortoResultError(context, result.Error());
        }
    }

    virtual TTickResult ProcessPortoResultSuccess(TTickContextPtr /* context */) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    }

    virtual TTickResult ProcessPortoResultError(TTickContextPtr /* context */, TPortoError& result) {
        ContainerStatusRepository_->UpdateContainerFailReason(Container_, ToString(result));
        ContainerStatusRepository_->IncrementContainerSystemFailureCounter(Container_);

        return TNodeError{
            ToString(result)
        };
    }

protected:
    const TStatusRepositoryCommonPtr ContainerStatusRepository_;
    const NStatusRepositoryTypes::TContainerDescription Container_;
    const TPortoContainerName ContainerName_;
};

} // namespace NInfra::NPodAgent
