#pragma once

#include "async_node.h"

#include <infra/pod_agent/libs/porto_client/async_client.h>

namespace NInfra::NPodAgent {

/**
    Porto Node with async call
        Child may return either
          Future<T> or ready TTickResult at PortoCall()
        In case of future child should process
          its value at ProcessPortoResult()
          and return TTickResult
*/
template<class T>
class TPortoBasicNode : public TAsyncNode<T> {
public:
    TPortoBasicNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
    )
        : TAsyncNode<T>(descriptor)
        , Porto_(porto)
    {
        Y_ENSURE(Porto_, "porto not defined for TPortoBasicNode");
    }

private:
    virtual TExpected<TFuture<T>, TTickResult> PrepareFuture(TTickContextPtr context) override final {
        Porto_ = Porto_->SwitchLogFrame(context->LogFrame);
        return PortoCall(context);
    }

    virtual TTickResult ProcessFutureResult(TTickContextPtr context, T& result) override final {
        return ProcessPortoResult(context, result);
    }

    virtual TExpected<NThreading::TFuture<T>, TTickResult> PortoCall(TTickContextPtr context) = 0;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, T& result) = 0;

protected:
    TAsyncPortoClientPtr Porto_;
};

} // namespace NInfra::NPodAgent
