#pragma once

#include "async_node.h"

#include "infra/pod_agent/libs/posix_worker/posix_worker.h"

namespace NInfra::NPodAgent {

template<class T>
class TPosixBasicNode : public TAsyncNode<T> {
public:
    TPosixBasicNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TPosixWorkerPtr posix
    )
        : TAsyncNode<T>(descriptor)
        , Posix_(posix)
    {
        Y_ENSURE(Posix_, "Posix not defined for TPosixBasicNode");
    }

private:
    virtual TExpected<NThreading::TFuture<T>, TTickResult> PrepareFuture(TTickContextPtr context) override final {
        return PosixCall(context);
    }

    virtual TTickResult ProcessFutureResult(TTickContextPtr context, T& result) override final {
        return ProcessPosixResult(context, result);
    }

    virtual NThreading::TFuture<T> PosixCall(TTickContextPtr context) = 0;
    virtual TTickResult ProcessPosixResult(TTickContextPtr context, T& result) = 0;

protected:
    TPosixWorkerPtr Posix_;
};

} // namespace NInfra::NPodAgent


