#pragma once

#include <util/generic/string.h>
#include <util/string/cast.h>

namespace NInfra::NPodAgent {

enum EContainerPrivate {
    CP_EXTRACTION_FAILURE = 0 /* "failure" */, // used when private value is not in the list, or tree hash is incorrect
    CP_EMPTY                  /* "" */,
    CP_READY                  /* "ready" */,
    CP_CHECKED                /* "checked" */,
    CP_TIMEOUT                /* "timeout" */,
    CP_DESTROY                /* "destroy" */,
};

enum ELayerPrivate {
    LP_EXTRACTION_FAILURE = 0 /* "failure" */, // used when private value is not in the list, or tree hash is incorrect
    LP_EMPTY                  /* "" */,
    LP_CLEANED                /* "cleaned" */,
};

template <class TEnum>
struct TPrivateUnpacked {
    TEnum Value_;
    TString TreeHash_;
};

template<class TEnum>
TString PackPrivate(const TPrivateUnpacked<TEnum>& pack) {
    return ToString(pack.Value_) + ":" + pack.TreeHash_;
}

template<class TEnum>
TPrivateUnpacked<TEnum> UnpackPrivate(const TString& privateValue) {
    size_t pos = privateValue.find_last_of(':');
    if (pos == TString::npos) {
        return {TEnum(0), ""};
    }
    try {
        return {FromString(privateValue.substr(0, pos)), privateValue.substr(pos + 1)};
    } catch (yexception& e) {
        return {TEnum(0), ""};
    }
}

using TContainerPrivateUnpacked = TPrivateUnpacked<EContainerPrivate>;
using TLayerPrivateUnpacked = TPrivateUnpacked<ELayerPrivate>;

TString PackContainerPrivate(const TContainerPrivateUnpacked& pack);
TString PackLayerPrivate(const TLayerPrivateUnpacked& pack);

TContainerPrivateUnpacked UnpackContainerPrivate(const TString& privateValue);
TLayerPrivateUnpacked UnpackLayerPrivate(const TString& privateValue);

} // namespace NInfra::NPodAgent
