#include "private_util.h"

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NTestPrivateUtil {

Y_UNIT_TEST_SUITE(ContainerPrivateUtilSuite) {
    Y_UNIT_TEST(TestPackUnpack) {
        TString packed = PackContainerPrivate({FromString("ready"), "tree_hash"});
        UNIT_ASSERT_EQUAL(UnpackContainerPrivate(packed).TreeHash_, "tree_hash");
        UNIT_ASSERT_EQUAL(UnpackContainerPrivate(packed).Value_, CP_READY);
        UNIT_ASSERT_EQUAL(PackContainerPrivate(UnpackContainerPrivate(packed)), packed);
        UNIT_ASSERT_EQUAL(UnpackContainerPrivate("not a valid value").Value_, CP_EXTRACTION_FAILURE);
        UNIT_ASSERT_EQUAL(UnpackContainerPrivate("not a valid value").TreeHash_, "");
        UNIT_ASSERT_EQUAL(UnpackContainerPrivate("value:treehash").Value_, CP_EXTRACTION_FAILURE);
        UNIT_ASSERT_EQUAL(UnpackContainerPrivate("value:treehash").TreeHash_, "");

        TString packedLayer = PackLayerPrivate({LP_CLEANED, "tree_hash"});
        UNIT_ASSERT_EQUAL(PackLayerPrivate(UnpackLayerPrivate(packedLayer)), packedLayer);
    }
}

} // namespace NInfra::NPodAgent::NTestPrivateUtil
