#include "time_expired_with_backoff_calcer.h"

namespace NInfra::NPodAgent {

TTickResult TTimeExpiredWithBackoffCalcer::CheckAndUpdateContext(const TInstant& startTime, ui32 step, TTickContextPtr context) const {
    TDuration interval = RoundToSeconds(Min(MaxRestartPeriod_, MinRestartPeriod_ + RestartPeriodScale_ * Power(RestartPeriodBackOff_, step)));
    TInstant now = TInstant::Now();

    if (now - startTime <= interval) {
        context->UpdateLongTickPeriodDuration((startTime + interval - now).MilliSeconds());
        return TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << "not expired: " << startTime);
    } else {
        context->UpdateLongTickPeriodDuration(0); // have to restart ASAP
        return TNodeSuccess(ENodeStatus::SUCCESS);
    }
}

} // namespace NInfra::NPodAgent
