#pragma once

#include "common.h"

#include <util/generic/ymath.h>

namespace NInfra::NPodAgent {

// Вершина возвращается Success, если истекло время, вычисляемое по формуле
// min(maxRestartPeriodMs, minRestartPeriodMs + restartPeriodScaleMs * (restartPeriodBackoff ^ step))
class TTimeExpiredWithBackoffCalcer {
public:
    TTimeExpiredWithBackoffCalcer(
        TDuration restartPeriodScale
        , ui64 restartPeriodBackOff
        , TDuration maxRestartPeriod
        , TDuration minRestartPeriod
    )
        : RestartPeriodScale_(restartPeriodScale)
        , RestartPeriodBackOff_(restartPeriodBackOff)
        , MaxRestartPeriod_(RoundToSeconds(maxRestartPeriod))
        , MinRestartPeriod_(minRestartPeriod)
    {
    }

    TTickResult CheckAndUpdateContext(const TInstant& startTime, ui32 step, TTickContextPtr context) const;

private:
    const TDuration RestartPeriodScale_;
    const ui64 RestartPeriodBackOff_;
    const TDuration MaxRestartPeriod_;
    const TDuration MinRestartPeriod_;
};

} // namespace NInfra::NPodAgent
