#pragma once

#include "basic_leaf.h"

namespace NInfra::NPodAgent {

class TVariableIsSetNode;
using TVariableIsSetNodePtr = TSimpleSharedPtr<TVariableIsSetNode>;

class TVariableIsSetNode : public TBasicLeaf {
public:
    TVariableIsSetNode(
        const TBasicTreeNodeDescriptor& descriptor
        , const TString& variable
    )
        : TBasicLeaf(descriptor)
        , Variable_(variable)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::VARIABLE_IS_SET;

private:
    const TString Variable_;
};

} // namespace NInfra::NPodAgent
