#include "variable_is_set_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestVariableIsSetNode {

Y_UNIT_TEST_SUITE(VariableIsSetNodeSuite) {

static TLogger logger({});

Y_UNIT_TEST(TestIsSet) {
    TVariableIsSetNodePtr node = new TVariableIsSetNode(TBasicTreeNodeDescriptor{1, "title"}, "set");
    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_EQUAL(ENodeStatus::SUCCESS, result.Success().Status);
}

Y_UNIT_TEST(TestIsNotSet) {
    TVariableIsSetNodePtr node = new TVariableIsSetNode(TBasicTreeNodeDescriptor{1, "title"}, "");
    auto result = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, result.Success().Status);
}

}

} // namespace NInfra::NPodAgent::NTestVariableIsSetNode
