#pragma once

#include "basic_leaf.h"

#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>

namespace NInfra::NPodAgent {

class TWorkloadBasicNode : public TBasicLeaf {
public:
    TWorkloadBasicNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
        , const TString& workloadId
    )
        : TBasicLeaf(descriptor)
        , WorkloadStatusRepository_(workloadStatusRepository)
        , WorkloadId_(workloadId)
    {
        Y_ENSURE(WorkloadStatusRepository_, "WorkloadStatusRepository not defined for TWorkloadBasicNode");
    }

protected:
    const TWorkloadStatusRepositoryPtr WorkloadStatusRepository_;
    const TString WorkloadId_;
};

} // namespace NInfra::NPodAgent
