#pragma once

#include "mem_sequence_node.h"

namespace NInfra::NPodAgent {

class TCaseNode;
using TCaseNodePtr = TSimpleSharedPtr<TCaseNode>;

class TCaseNode : public TMemSequenceNode {
public:
    TCaseNode(
        const TBasicTreeNodeDescriptor& descriptor
        , const TString& caseValue
    )
        : TMemSequenceNode(descriptor, {})
        , CaseValue_(caseValue)
        , Default_(caseValue == DEFAULT_CASE_VALUE)
    {
    }

    virtual ENodeType GetType() const override final;

    const TString& GetCaseValue() const;
    bool IsDefault() const;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::CASE;
    static constexpr const char* DEFAULT_CASE_VALUE = "default";

private:
    const TString CaseValue_;
    const bool Default_ = false;
};

} // namespace NInfra::NPodAgent
