#include "case_node.h"

#include <infra/libs/logger/logger.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NTestCaseNode {

Y_UNIT_TEST_SUITE(CaseNodeSuite) {

static TLogger logger({});

Y_UNIT_TEST(TestDefaultCase) {
    {
        TCaseNodePtr node = new TCaseNode({1, "title"}, TCaseNode::DEFAULT_CASE_VALUE);
        UNIT_ASSERT(node->IsDefault());
    }
    {
        TCaseNodePtr node = new TCaseNode({1, "title"}, TString(TCaseNode::DEFAULT_CASE_VALUE) + "_suffix");
        UNIT_ASSERT(!node->IsDefault());
    }
}

}

} // namespace NInfra::NPodAgent::NTestCaseNode
