#include "inverter_node.h"

#include <util/string/builder.h>

namespace NInfra::NPodAgent {

ENodeType TInverterNode::GetType() const {
    return TInverterNode::NODE_TYPE;
}

void TInverterNode::SetChildren(TVector<TBasicTreeNodePtr>&& children) {
    Y_ENSURE(children.size() == 1, "Inverter should have one child");
    TBasicCompositeNode::SetChildren(std::move(children));
}

TTickResult TInverterNode::TickImpl(TTickContextPtr tickContext) {
    if (GetChildren().size() != 1) {
        return TTickResult(TNodeError{
                TStringBuilder() << "Inverter should have one child, but has "
                                 << GetChildren().size()
        });
    }
    auto child = GetChildren().at(0);
    auto tickResult = OUTCOME_TRYX(child->Tick(tickContext));
    switch (tickResult.Status) {
        case ENodeStatus::FAILURE:
            return TNodeSuccess(ENodeStatus::SUCCESS, tickResult.Message);

        case ENodeStatus::RUNNING:
            return TNodeSuccess(ENodeStatus::RUNNING, tickResult.Message);

        case ENodeStatus::SUCCESS:
            return TNodeSuccess(ENodeStatus::FAILURE, tickResult.Message);

        default:
            return TNodeError{
                    TStringBuilder() << "Inverter child "
                                     << "  " << child->GetType()
                                     << "  " << child->GetTitle()
                                     << " returned unexpected status: " << tickResult.Status};
    }
}

} // namespace NInfra::NPodAgent
