#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/basic_composite_node.h>

namespace NInfra::NPodAgent {

/**
 * Invertor
 *
 * Has exactly one child
 *
 * If the child returns SUCCESS - InvertorNode returns FAILURE
 * If the child returns RUNNING - InvertorNode returns RUNNING
 * If the child returns FAILURE - InvertorNode returns SUCCESS
 */

class TInverterNode;
using TInverterNodePtr = TSimpleSharedPtr<TInverterNode>;

class TInverterNode : public TBasicCompositeNode {
public:
    TInverterNode(
        const TBasicTreeNodeDescriptor& descriptor
    )
        : TBasicCompositeNode(descriptor, {})
    {}

    virtual ENodeType GetType() const override final;

    virtual void SetChildren(TVector<TBasicTreeNodePtr>&& children) override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr tickContext) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::INVERTER;
};


} // namespace NInfra::NPodAgent
