#include "inverter_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/mock_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>

#include <infra/libs/logger/logger.h>
#include <infra/libs/logger/log_frame.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NTestInverterNode {

Y_UNIT_TEST_SUITE(InvertorNodeSuite) {

static TLogger logger({});

TInverterNodePtr SingleChildInvertor(TTickResult tickResult) {
    TInverterNodePtr result = new TInverterNode(TBasicTreeNodeDescriptor{1, "title"});
    result->SetChildren({new TMockNode({1, "title"}, tickResult)});
    return result;
}

Y_UNIT_TEST(TestWithOneFailedChild) {
    TTickResult expected = TNodeError{"test error message"};

    auto invertor = SingleChildInvertor(expected);

    auto result = invertor->Tick(MockTickContext(logger));
    UNIT_ASSERT_EQUAL(expected, result);
}

Y_UNIT_TEST(TestWithTwoChild) {
    TTickResult expected = TNodeError{"test error message"};
    auto invertor = SingleChildInvertor(expected);
    UNIT_ASSERT_EXCEPTION_CONTAINS(
        (invertor->SetChildren({new TMockNode({1, "title"}, expected), new TMockNode({1, "title"}, expected)}))
        , yexception
        , "Inverter should have one child"
    );
}

Y_UNIT_TEST(TestWithOneSuccessChild) {
    std::pair<ENodeStatus, ENodeStatus> const goodStatuses[] = {
        {ENodeStatus::SUCCESS, ENodeStatus::FAILURE}
        , {ENodeStatus::FAILURE, ENodeStatus::SUCCESS}
        , {ENodeStatus::RUNNING, ENodeStatus::RUNNING}
    };

    for (auto&& status : goodStatuses) {
        TTickResult outcome(status.first);
        auto invertor = SingleChildInvertor(outcome);

        TTickResult expected(status.second);
        auto result = invertor->Tick(MockTickContext(logger));
        UNIT_ASSERT_EQUAL(expected, result);
    }
}

Y_UNIT_TEST(TesWithOneUnexpextedChildStatus) {
    TTickResult idleChild(ENodeStatus::IDLE);

    auto invertor = SingleChildInvertor(idleChild);

    auto result = invertor->Tick(MockTickContext(logger));
    UNIT_ASSERT_STRING_CONTAINS(result.Error().Message, "unexpected status");
}

}

} // namespace NInfra::NPodAgent::NTestInverterNode
