#include "mem_selector_node.h"

#include <util/string/builder.h>

namespace NInfra::NPodAgent {

ENodeType TMemSelectorNode::GetType() const {
    return TMemSelectorNode::NODE_TYPE;
}

TTickResult TMemSelectorNode::TickImpl(TTickContextPtr tickContext) {
    if (CurrentFocusedChildNumber_ >= GetChildren().size()) {
        return TTickResult(TNodeError{
                TStringBuilder() << "Current focused child number "
                                 << CurrentFocusedChildNumber_
                                 << " can't be more then total children number "
                                 << GetChildren().size()
        });
    }

    if (CurrentFocusedChildNumber_ == 0) {
        LastChildFailure_ = TNodeSuccess(ENodeStatus::FAILURE);
    }

    for (; CurrentFocusedChildNumber_ < GetChildren().size(); ++CurrentFocusedChildNumber_) {
        auto child = GetChildren().at(CurrentFocusedChildNumber_);
        auto tickResult = child->Tick(tickContext);
        if (!tickResult) {
            CurrentFocusedChildNumber_ = 0;
            return tickResult.Error();
        }
        switch (tickResult.Success().Status) {
            case ENodeStatus::FAILURE:
                LastChildFailure_ = tickResult.Success();
                break;

            case ENodeStatus::RUNNING:
                return tickResult.Success();

            case ENodeStatus::SUCCESS:
                CurrentFocusedChildNumber_ = 0;
                return tickResult.Success();

            default:
                return TNodeError{
                        TStringBuilder() << "Current focused child "
                                         << CurrentFocusedChildNumber_
                                         << "  " << child->GetType()
                                         << "  " << child->GetTitle()
                                         << " returned unexpected status: " << tickResult.Success().Status};
        }
    }
    CurrentFocusedChildNumber_ = 0;
    return LastChildFailure_;
}

} // namespace NInfra::NPodAgent
