#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/basic_composite_node.h>

namespace NInfra::NPodAgent {

/**
 * MemSelector
 *
 * Visits each child in vector from first to last until first SUCCESS
 *
 * Holds pointer to current child
 * If the child returns SUCCESS - MemSelectorNode returns SUCCESS
 * If the child returns RUNNING - MemSelectorNode returns RUNNING
 * If the child returns FAILURE :
 *   if the child is not the last - MemSelectorNode increments the pointer and returns RUNNING
 *   if the child is the last - MemSelectorNode returns FAILURE
 */

class TMemSelectorNode;
using TMemSelectorNodePtr = TSimpleSharedPtr<TMemSelectorNode>;

class TMemSelectorNode : public TBasicCompositeNode {
public:
    TMemSelectorNode(
        const TBasicTreeNodeDescriptor& descriptor
        , const TVector<TBasicTreeNodePtr>& children
    )
        : TBasicCompositeNode(descriptor, children)
        , CurrentFocusedChildNumber_(0)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr tickContext) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::MEM_SELECTOR;

private:
    size_t CurrentFocusedChildNumber_;
    TNodeSuccess LastChildFailure_;
};


} // namespace NInfra::NPodAgent
