#include "mem_sequence_node.h"

#include <util/string/builder.h>

namespace NInfra::NPodAgent {

ENodeType TMemSequenceNode::GetType() const {
    return TMemSequenceNode::NODE_TYPE;
}

TTickResult TMemSequenceNode::TickImpl(TTickContextPtr tickContext) {
    if (CurrentFocusedChildNumber_ >= GetChildren().size()) {
        return TTickResult(TNodeError{
                TStringBuilder() << "Current focused child number "
                                 << CurrentFocusedChildNumber_
                                 << " can't be more then total children number "
                                 << GetChildren().size()
        });
    }

    if (CurrentFocusedChildNumber_ == 0) {
        LastChildSuccess_ = TNodeSuccess(ENodeStatus::SUCCESS);
    }

    for (; CurrentFocusedChildNumber_ < GetChildren().size(); ++CurrentFocusedChildNumber_) {
        auto child = GetChildren().at(CurrentFocusedChildNumber_);
        auto tickResult = child->Tick(tickContext);
        if (!tickResult) {
            CurrentFocusedChildNumber_ = 0;
            return tickResult.Error();
        }
        switch (tickResult.Success().Status) {
            case ENodeStatus::FAILURE:
                CurrentFocusedChildNumber_ = 0;
                return tickResult.Success();

            case ENodeStatus::RUNNING:
                return tickResult.Success();

            case ENodeStatus::SUCCESS:
                LastChildSuccess_ = tickResult.Success();
                break;

            default:
                return TNodeError{
                        TStringBuilder() << "Current focused child "
                                         << CurrentFocusedChildNumber_
                                         << "  " << child->GetType()
                                         << "  " << child->GetTitle()
                                         << " returned unexpected status: " << tickResult.Success().Status};
        }
    }
    CurrentFocusedChildNumber_ = 0;
    return LastChildSuccess_;
}

} // namespace NInfra::NPodAgent
