#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/basic_composite_node.h>

namespace NInfra::NPodAgent {

/**
 * MemSequence
 *
 * Visits each child in vector from first to last
 *
 * Holds pointer to current child
 * If the child returns FAILURE - MemSequenceNode returns FAILURE
 * If the child returns RUNNING - MemSequenceNode returns RUNNING
 * If the child returns SUCCESS :
 *   if the child is not the last - MemSequenceNode increments the pointer and returns RUNNING
 *   if the child is the last - MemSequenceNode returns SUCCESS
 */

class TMemSequenceNode;
using TMemSequenceNodePtr = TSimpleSharedPtr<TMemSequenceNode>;

class TMemSequenceNode : public TBasicCompositeNode {
public:
    TMemSequenceNode(
        const TBasicTreeNodeDescriptor& descriptor
        , const TVector<TBasicTreeNodePtr>& children
    )
        : TBasicCompositeNode(descriptor, children)
        , CurrentFocusedChildNumber_(0)
    {}

    virtual ENodeType GetType() const override; // not final because case_node

private:
    virtual TTickResult TickImpl(TTickContextPtr tickContext) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::MEM_SEQUENCE;

private:
    size_t CurrentFocusedChildNumber_;
    TNodeSuccess LastChildSuccess_;
};


} // namespace NInfra::NPodAgent
