#include "timed_cache_node.h"

#include <util/string/builder.h>
#include <util/string/cast.h>

namespace NInfra::NPodAgent {

ENodeType TTimedCacheNode::GetType() const {
    return TTimedCacheNode::NODE_TYPE;
}

void TTimedCacheNode::SetChildren(TVector<TBasicTreeNodePtr>&& children) {
    Y_ENSURE(children.size() == 1, "TimedCacheNode should have one child");
    TBasicCompositeNode::SetChildren(std::move(children));
}

TTickResult TTimedCacheNode::TickImpl(TTickContextPtr tickContext) {
    if (GetChildren().size() != 1) {
        return TNodeError{
            TStringBuilder() << "TimedCacheNode should have one child, but has "
                             << GetChildren().size()
        };
    }

    auto child = GetChildren()[0];

    // Go to running child
    if (LastResult_ && LastResult_.Success().Status == ENodeStatus::RUNNING) {
        LastResult_ = child->Tick(tickContext);
        // Safe time after tick
        LastRun_ = TInstant::Now();
        return LastResult_;
    }

    // Skip child by timeout
    if (LastResult_ && TInstant::Now() < LastRun_ + Timeout_) {
        return TNodeSuccess(
            LastResult_.Success().Status
            , TStringBuilder() << "Skiped by timeout " << ToString(Timeout_)
                               << ": last run at " << ToString(LastRun_)
                               << ". Last message: ('" << LastResult_.Success().Message << "')"
        );
    }

    LastResult_ = child->Tick(tickContext);
    // Safe time after tick
    LastRun_ = TInstant::Now();
    return LastResult_;
}

} // namespace NInfra::NPodAgent
