#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/basic_composite_node.h>

namespace NInfra::NPodAgent {

/**
 * TimedCacheNode
 *
 * Has exactly one child
 *
 * If the timeout expired or last result was RUNNING or Error returns the result of the only child
 * Otherwise does not start child and returns last result
 *
 */

class TTimedCacheNode;
using TTimedCacheNodePtr = TSimpleSharedPtr<TTimedCacheNode>;

class TTimedCacheNode : public TBasicCompositeNode {
public:
    TTimedCacheNode(
        const TBasicTreeNodeDescriptor& descriptor
        , const TDuration& timeout
    )
        : TBasicCompositeNode(descriptor, {})
        , Timeout_(timeout)
        , LastRun_(TInstant::Zero())
        , LastResult_(TNodeSuccess())
    {}

    virtual ENodeType GetType() const override final;

    virtual void SetChildren(TVector<TBasicTreeNodePtr>&& children) override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr tickContext) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::TIMED_CACHE;

private:
    const TDuration Timeout_;
    TInstant LastRun_;
    TTickResult LastResult_;
};


} // namespace NInfra::NPodAgent
