#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/capture_status_basic_node.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TCaptureContainerStatusNode;
using TCaptureContainerStatusNodePtr = TSimpleSharedPtr<TCaptureContainerStatusNode>;

class TCaptureContainerStatusNode : public TCaptureStatusBasicNode<TExpected<void, TSystemLogsSenderError>> {
public:
    TCaptureContainerStatusNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr containerStatusRepository
        , ISystemLogsSenderPtr systemLogsSender
        , const NStatusRepositoryTypes::TContainerDescription& container
    )
        : TCaptureStatusBasicNode(descriptor, systemLogsSender)
        , ContainerStatusRepository_(containerStatusRepository)
        , Container_(container)
    {
        Y_ENSURE(ContainerStatusRepository_, "ContainerStatusRepository not defined for TCaptureContainerStatusNode");
    }

    virtual ENodeType GetType() const override final;

//public for tests
public:
    NLogEvent::TContainerAttemptFeedback CreateLogEvent(const API::TContainerStatus::TAttemptFeedback& feedback,
                                                        const TVector<TString>& objectIds,
                                                        const TVector<TStatusRepositoryCommon::TCacheObject>& cacheObjects);

    TString SystemLogMessage(NLogEvent::TContainerAttemptFeedback logEvent);

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::CAPTURE_CONTAINER_STATUS;

private:
    virtual TExpected<NThreading::TFuture<TExpected<void, TSystemLogsSenderError>>, TTickResult> CaptureStatus(TTickContextPtr context) override final;
    virtual TTickResult ProcessResult(TTickContextPtr context, TExpected<void, TSystemLogsSenderError>& result) override final;

private:
    TStatusRepositoryCommonPtr ContainerStatusRepository_;
    const NStatusRepositoryTypes::TContainerDescription Container_;
};

} // namespace NInfra::NPodAgent
