#include "check_container_retries_node.h"

namespace NInfra::NPodAgent {

ENodeType TCheckContainerRetriesNode::GetType() const {
    return TCheckContainerRetriesNode::NODE_TYPE;
}

TTickResult TCheckContainerRetriesNode::TickImpl(TTickContextPtr) {
    if (MaxTries_ == 0) {
        return TNodeError{"Check container retries node must be unreachable when MaxTries is zero"};
    }


    ui32 tries =
        ContainerStatusRepository_->GetContainerZeroReturnCodeCounter(Container_)
        + ContainerStatusRepository_->GetContainerPositiveReturnCodeCounter(Container_)
        + ContainerStatusRepository_->GetContainerOomCounter(Container_)
        + ContainerStatusRepository_->GetContainerKilledExternallyCounter(Container_)
        + ContainerStatusRepository_->GetContainerSystemFailureCounter(Container_);

    if (tries < MaxTries_) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder()
            << "Workload '" << Container_.ObjectIdOrHash_
            << "' exceeded " << Container_.ContainerType_
            << " tries limit: " << MaxTries_
        );
    }
}

} // namespace NInfra::NPodAgent
