#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/feedback_container_basic_node.h>

namespace NInfra::NPodAgent {

class TCheckContainerRetriesNode;
using TCheckContainerRetriesNodePtr = TSimpleSharedPtr<TCheckContainerRetriesNode>;

class TCheckContainerRetriesNode : public TFeedbackContainerBasicNode {
public:
    TCheckContainerRetriesNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr workloadStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
        , ui32 maxTries
    )
        : TFeedbackContainerBasicNode(descriptor, workloadStatusRepository, container)
        , MaxTries_(maxTries)
    {
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::CHECK_CONTAINER_RETRIES;

private:
    const ui32 MaxTries_;
};

} // namespace NInfra::NPodAgent
