#include "container_consecutive_tries_reached_node.h"

namespace NInfra::NPodAgent {

ENodeType TContainerConsecutiveTriesReachedNode::GetType() const {
    return TContainerConsecutiveTriesReachedNode::NODE_TYPE;
}

TTickResult TContainerConsecutiveTriesReachedNode::TickImpl(TTickContextPtr /*context*/) {
    ui32 consecutiveTries = CountSuccesses_
        ? ContainerStatusRepository_->GetContainerConsecutiveSuccessesCounter(Container_)
        : ContainerStatusRepository_->GetContainerConsecutiveFailuresCounter(Container_);
    if (consecutiveTries >= TriesThreshold_) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        return TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << consecutiveTries << " not reached " << TriesThreshold_);
    }
}

} // namespace NInfra::NPodAgent
