#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/feedback_container_basic_node.h>

namespace NInfra::NPodAgent {

class TContainerConsecutiveTriesReachedNode;
using TContainerConsecutiveTriesReachedNodePtr = TSimpleSharedPtr<TContainerConsecutiveTriesReachedNode>;

class TContainerConsecutiveTriesReachedNode : public TFeedbackContainerBasicNode {
public:
    TContainerConsecutiveTriesReachedNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr statusRepositoryCommon
        , const NStatusRepositoryTypes::TContainerDescription& container
        , bool countSuccesses
        , ui32 triesThreshold
    )
        : TFeedbackContainerBasicNode(
            descriptor
            , statusRepositoryCommon
            , container
        )
        , CountSuccesses_(countSuccesses)
        , TriesThreshold_(triesThreshold)
    {
        Y_ENSURE(TriesThreshold_, "triesThreshold should not be zero");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::CONTAINER_CONSECUTIVE_TRIES_REACHED;

private:
    const bool CountSuccesses_;
    const ui32 TriesThreshold_;
};

} // namespace NInfra::NPodAgent
