#include "container_consecutive_tries_reached_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestContainerConsecutiveTriesReachedNode {

TContainerConsecutiveTriesReachedNodePtr CreateNode(
    TStatusRepositoryCommonPtr statusRepositoryCommon
    , const NStatusRepositoryTypes::TContainerDescription& container
    , bool countSuccesses
    , ui32 triesThreshold
) {
    return TContainerConsecutiveTriesReachedNodePtr(new TContainerConsecutiveTriesReachedNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , statusRepositoryCommon
        , container
        , countSuccesses
        , triesThreshold
    ));
}

static TLogger logger({});
static const TString WORKLOAD_ID = "my_workload";
static const NStatusRepositoryTypes::TContainerDescription CONTAINER(
    WORKLOAD_ID
    , NStatusRepositoryTypes::EObjectType::WORKLOAD
    , NStatusRepositoryTypes::TContainerDescription::EContainerType::DESTROY
);

Y_UNIT_TEST_SUITE(ContainerConsecutiveTriesReachedSuite) {

Y_UNIT_TEST(TestContainerTriesNotReached) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(WORKLOAD_ID));

    for (int i = 0; i <= 1; ++i) {
        bool resultSuccess = (bool)i;
        holder->UpdateContainerConsecutiveFailuresAndSuccessesCounter(CONTAINER, resultSuccess ? 0 : 42);

        auto node = CreateNode(holder, CONTAINER, resultSuccess, 3);

        auto result = node->Tick(MockTickContext(logger));

        UNIT_ASSERT_C(result, result.Error().Message);
        UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, result.Success().Status);
    }
}

Y_UNIT_TEST(TestContainerTriesReached) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(WORKLOAD_ID));

    for (int i = 0; i <= 1; ++i) {
        bool resultSuccess = (bool)i;
        holder->UpdateContainerConsecutiveFailuresAndSuccessesCounter(CONTAINER, resultSuccess ? 0 : 42);
        holder->UpdateContainerConsecutiveFailuresAndSuccessesCounter(CONTAINER, resultSuccess ? 0 : 42);
        holder->UpdateContainerConsecutiveFailuresAndSuccessesCounter(CONTAINER, resultSuccess ? 0 : 42);

        auto node = CreateNode(holder, CONTAINER, resultSuccess, 3);

        auto result = node->Tick(MockTickContext(logger));

        UNIT_ASSERT_C(result, result.Error().Message);
        UNIT_ASSERT_EQUAL_C(ENodeStatus::SUCCESS, result.Success().Status, result.Success().Message);
    }
}

Y_UNIT_TEST(TestBadTriesThreshold) {
    TWorkloadStatusRepositoryPtr holder = new TWorkloadStatusRepository();
    holder->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(WORKLOAD_ID));

    UNIT_ASSERT_EXCEPTION_CONTAINS(
        CreateNode(holder, CONTAINER, true, 0)
        , yexception
        , "triesThreshold should not be zero"
    );
}

}

} // namespace NInfra::NPodAgent::NTestContainerConsecutiveTriesReachedNode
