#include "container_start_time_expired_with_backoff_node.h"

namespace NInfra::NPodAgent {

ENodeType TContainerStartTimeExpiredNodeWithBackOff::GetType() const {
    return TContainerStartTimeExpiredNodeWithBackOff::NODE_TYPE;
}

TTickResult TContainerStartTimeExpiredNodeWithBackOff::TickImpl(TTickContextPtr context) {
    // step = Max(0, ConsecutiveFailuresCounter - 1) for workload stop
    // step = Max(0, ConsecutiveSuccessesCounter - 1) for all other containers
    ui32 step = (Container_.ObjectType_ == NStatusRepositoryTypes::EObjectType::WORKLOAD
        && (Container_.ContainerType_ == NStatusRepositoryTypes::TContainerDescription::EContainerType::STOP ||
            Container_.ContainerType_ == NStatusRepositoryTypes::TContainerDescription::EContainerType::DESTROY))
        ? ( Max(1u, ContainerStatusRepository_->GetContainerConsecutiveFailuresCounter(Container_)) - 1 )
        : ( Max(1u, ContainerStatusRepository_->GetContainerConsecutiveSuccessesCounter(Container_)) - 1 );
    return BackoffCalcer_.CheckAndUpdateContext(
        ContainerStatusRepository_->GetContainerStartTime(Container_),
        step,
        context
    );
}

} // namespace NInfra::NPodAgent
