#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/basic_leaf.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/time_expired_with_backoff_calcer.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TContainerStartTimeExpiredNodeWithBackOff;
using TContainerStartTimeExpiredNodeWithBackOffPtr = TSimpleSharedPtr<TContainerStartTimeExpiredNodeWithBackOff>;

class TContainerStartTimeExpiredNodeWithBackOff : public TBasicLeaf {
public:
    TContainerStartTimeExpiredNodeWithBackOff(
        const TBasicTreeNodeDescriptor& descriptor
        , TStatusRepositoryCommonPtr containerStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
        , TDuration minRestartPeriod
        , TDuration restartPeriodScale
        , ui64 restartPeriodBackOff
        , TDuration maxRestartPeriod
    )
        : TBasicLeaf(descriptor)
        , BackoffCalcer_(
            restartPeriodScale
            , restartPeriodBackOff
            , maxRestartPeriod
            , minRestartPeriod
        )
        , ContainerStatusRepository_(containerStatusRepository)
        , Container_(container)
    {
        Y_ENSURE(ContainerStatusRepository_, "ContainerStatusRepository not defined for TContainerStartTimeExpiredNodeWithBackOff");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TTickResult TickImpl(TTickContextPtr context) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::CONTAINER_START_TIME_EXPIRED_WITH_BACK_OFF;

private:
    const TTimeExpiredWithBackoffCalcer BackoffCalcer_;
    const TStatusRepositoryCommonPtr ContainerStatusRepository_;
    const NStatusRepositoryTypes::TContainerDescription Container_;
};

} // namespace NInfra::NPodAgent
