#include "feedback_container_death_time_node.h"

namespace NInfra::NPodAgent {

ENodeType TFeedbackContainerDeathTimeNode::GetType() const {
    return TFeedbackContainerDeathTimeNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TFeedbackContainerDeathTimeNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->GetProperty(ContainerName_, EPortoContainerProperty::DeathTimeRaw);
}

TTickResult TFeedbackContainerDeathTimeNode::ProcessPortoResultSuccess(TTickContextPtr /*context*/, TString& result) {
    try {
        ContainerStatusRepository_->UpdateContainerDeathTime(Container_, TInstant::Seconds(FromString<time_t>(result)));

        return TNodeSuccess(ENodeStatus::SUCCESS);
    } catch (const yexception& e) {
        return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
    }
}

} // namespace NInfra::NPodAgent
